
// Sprite definitions
#include "sprites.h"

const u8 palette[4] = {0, 4, 12, 15};
const u8 explosionpalette[4][4] = {
  {4, 24, 25, 26},
  {1, 15, 24, 25},
  {0, 6, 15, 24},
  {0, 4, 12, 15}
};

const u8 platformempty[64] = {
  0x0F, 0x0F, 0x0F, 0x0F,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x08, 0x00, 0x00, 0x01,
  0x0F, 0x0F, 0x0F, 0x0F
};

const u8 line[4] = {
  0x78, 0xF0, 0xF0, 0xE1
};

const u8 rocket[4][64] = {
  {0x00, 0xFF, 0xFF, 0x00,
    0x11, 0x5F, 0x5A, 0x80,
    0x23, 0xAF, 0x0F, 0xC0,
    0x33, 0x0F, 0x5A, 0xC0,
    0x23, 0xAF, 0x0F, 0xC0,
    0x33, 0x87, 0x5A, 0xC0,
    0x00, 0xF8, 0xF0, 0x00,
    0x00, 0xEF, 0xBE, 0x00,
    0x11, 0x4F, 0x5A, 0x80,
    0x23, 0x8F, 0x0F, 0xC0,
    0x33, 0x4F, 0x5A, 0x48,
    0x23, 0xBC, 0xF0, 0xC0,
    0x33, 0x08, 0x01, 0xC0,
    0x23, 0x00, 0x00, 0x48,
    0x46, 0x00, 0x00, 0x24,
    0x8C, 0x00, 0x00, 0x12},
  {0x00, 0x11, 0x88, 0x00,
    0x00, 0x23, 0x84, 0x00,
    0x00, 0x57, 0x68, 0x00,
    0x00, 0x67, 0xA4, 0x00,
    0x00, 0x57, 0x68, 0x00,
    0x00, 0x67, 0xA4, 0x00,
    0x00, 0x57, 0x68, 0x00,
    0x00, 0x67, 0xA4, 0x00,
    0x00, 0x57, 0x68, 0x00,
    0x00, 0x67, 0xA4, 0x00,
    0x00, 0x57, 0x68, 0x00,
    0x00, 0x67, 0xA4, 0x00,
    0x00, 0x9F, 0x5E, 0x00,
    0x11, 0x69, 0x6B, 0x80,
    0x23, 0x91, 0x91, 0x48,
    0x56, 0x11, 0x80, 0xAC},
  {0x00, 0x11, 0x88, 0x00,
    0x00, 0x11, 0x80, 0x00,
    0x00, 0x11, 0x80, 0x00,
    0x00, 0x23, 0xC0, 0x00,
    0x00, 0x23, 0x48, 0x00,
    0x00, 0x67, 0xA4, 0x00,
    0x00, 0xCF, 0x78, 0x00,
    0x00, 0xAF, 0xB4, 0x00,
    0x11, 0x4F, 0x78, 0x80,
    0x11, 0xAF, 0xB4, 0x80,
    0x11, 0x4F, 0x78, 0x80,
    0x33, 0xBC, 0xF0, 0xC0,
    0x33, 0x08, 0x01, 0xC0,
    0x23, 0x00, 0x00, 0x48,
    0x46, 0x00, 0x00, 0x60,
    0x8F, 0x08, 0x10, 0xF0},
  {0x00, 0x77, 0xEE, 0x00,
    0x00, 0xCF, 0x3C, 0x00,
    0x11, 0x9E, 0x5A, 0x80,
    0x11, 0xF0, 0xF0, 0x80,
    0x33, 0xFE, 0xFA, 0x48,
    0x33, 0xAF, 0x3C, 0xC0,
    0x23, 0x9E, 0x5A, 0x48,
    0x33, 0xAF, 0x3C, 0xC0,
    0x23, 0x9E, 0x5A, 0x48,
    0x33, 0xAF, 0x3C, 0xC0,
    0x23, 0xDA, 0x5A, 0x48,
    0x32, 0xF0, 0xF0, 0xC0,
    0x32, 0x01, 0x80, 0xC8,
    0x56, 0x01, 0x80, 0xAC,
    0x56, 0x01, 0x80, 0xAC,
    0x9E, 0x01, 0x80, 0x9E}
};

const u8 rocketshield1[4][64] = {
  {0x00, 0x0F, 0x0F, 0x00,
    0x01, 0x5F, 0x5A, 0x08,
    0x03, 0xAF, 0x0F, 0x84,
    0x13, 0x0F, 0x5A, 0x84,
    0x03, 0xAF, 0x0F, 0x84,
    0x03, 0x87, 0x5A, 0x0C,
    0x00, 0x78, 0xE1, 0x00,
    0x00, 0x6F, 0xAF, 0x00,
    0x01, 0x4F, 0x5A, 0x08,
    0x03, 0x8F, 0x0F, 0x84,
    0x13, 0x4F, 0x5A, 0x0C,
    0x03, 0x8F, 0x1E, 0x84,
    0x13, 0x08, 0x01, 0x84,
    0x03, 0x00, 0x00, 0x0C,
    0x06, 0x00, 0x00, 0x06,
    0x0C, 0x00, 0x00, 0x03},
  {0x00, 0x01, 0x08, 0x00,
    0x00, 0x03, 0x84, 0x00,
    0x00, 0x17, 0x4A, 0x00,
    0x00, 0x27, 0x86, 0x00,
    0x00, 0x17, 0x4A, 0x00,
    0x00, 0x27, 0x86, 0x00,
    0x00, 0x17, 0x4A, 0x00,
    0x00, 0x27, 0x86, 0x00,
    0x00, 0x17, 0x4A, 0x00,
    0x00, 0x27, 0x86, 0x00,
    0x00, 0x17, 0x4A, 0x00,
    0x00, 0x27, 0x86, 0x00,
    0x00, 0x1F, 0x4F, 0x00,
    0x01, 0x0F, 0x0F, 0x08,
    0x03, 0x09, 0x09, 0x0C,
    0x07, 0x01, 0x08, 0x0E},
  {0x00, 0x01, 0x08, 0x00,
    0x00, 0x01, 0x08, 0x00,
    0x00, 0x01, 0x08, 0x00,
    0x00, 0x03, 0x84, 0x00,
    0x00, 0x03, 0x0C, 0x00,
    0x00, 0x27, 0x86, 0x00,
    0x00, 0x4F, 0x69, 0x00,
    0x00, 0x2F, 0xA5, 0x00,
    0x01, 0x4F, 0x78, 0x08,
    0x01, 0xAF, 0xB4, 0x08,
    0x01, 0x4F, 0x78, 0x08,
    0x13, 0x8F, 0x1E, 0x84,
    0x13, 0x08, 0x01, 0x84,
    0x03, 0x00, 0x00, 0x0C,
    0x06, 0x00, 0x00, 0x06,
    0x0F, 0x08, 0x01, 0x0F},
  {0x00, 0x07, 0x0E, 0x00,
    0x00, 0x4F, 0x2D, 0x00,
    0x01, 0x9E, 0x5A, 0x08,
    0x01, 0xF0, 0xF0, 0x08,
    0x13, 0xFE, 0xFA, 0x0C,
    0x13, 0xAF, 0x3C, 0x84,
    0x03, 0x9E, 0x5A, 0x0C,
    0x13, 0xAF, 0x3C, 0x84,
    0x03, 0x9E, 0x5A, 0x0C,
    0x13, 0xAF, 0x3C, 0x84,
    0x03, 0xDA, 0x5A, 0x0C,
    0x03, 0x1E, 0x87, 0x0C,
    0x03, 0x01, 0x08, 0x0C,
    0x07, 0x01, 0x08, 0x0E,
    0x07, 0x01, 0x08, 0x0E,
    0x0F, 0x01, 0x08, 0x0F}
};

const u8 rocketshield2[4][64] = {
  {0x00, 0xFF, 0xFF, 0x00,
    0x11, 0x5F, 0x5A, 0x88,
    0x23, 0xAF, 0x0F, 0xC4,
    0x33, 0x0F, 0x5A, 0xC4,
    0x23, 0xAF, 0x0F, 0xC4,
    0x33, 0x87, 0x5A, 0xCC,
    0x00, 0xF8, 0xF1, 0x00,
    0x00, 0xEF, 0xBF, 0x00,
    0x11, 0x4F, 0x5A, 0x88,
    0x23, 0x8F, 0x0F, 0xC4,
    0x33, 0x4F, 0x5A, 0x4C,
    0x23, 0xFF, 0xFE, 0xC4,
    0x33, 0x88, 0x11, 0xC4,
    0x33, 0x00, 0x00, 0xCC,
    0x66, 0x00, 0x00, 0x66,
    0xCC, 0x00, 0x00, 0x33},
  {0x00, 0x11, 0x88, 0x00,
    0x00, 0x23, 0xC4, 0x00,
    0x00, 0x57, 0x6A, 0x00,
    0x00, 0x67, 0xA6, 0x00,
    0x00, 0x57, 0x6A, 0x00,
    0x00, 0x67, 0xA6, 0x00,
    0x00, 0x57, 0x6A, 0x00,
    0x00, 0x67, 0xA6, 0x00,
    0x00, 0x57, 0x6A, 0x00,
    0x00, 0x67, 0xA6, 0x00,
    0x00, 0x57, 0x6A, 0x00,
    0x00, 0x67, 0xA6, 0x00,
    0x00, 0x9F, 0x5F, 0x00,
    0x11, 0x6F, 0x6F, 0x88,
    0x23, 0x99, 0x99, 0x4C,
    0x77, 0x11, 0x88, 0xEE},
  {0x00, 0x11, 0x88, 0x00,
    0x00, 0x11, 0x88, 0x00,
    0x00, 0x11, 0x88, 0x00,
    0x00, 0x23, 0xC4, 0x00,
    0x00, 0x23, 0x4C, 0x00,
    0x00, 0x67, 0xA6, 0x00,
    0x00, 0xCF, 0x79, 0x00,
    0x00, 0xAF, 0xB5, 0x00,
    0x11, 0x4F, 0x78, 0x88,
    0x11, 0xAF, 0xB4, 0x88,
    0x11, 0x4F, 0x78, 0x88,
    0x33, 0xFF, 0xFE, 0xC4,
    0x33, 0x88, 0x11, 0xC4,
    0x33, 0x00, 0x00, 0xCC,
    0x66, 0x00, 0x00, 0x66,
    0xFF, 0x88, 0x11, 0xFF},
  {0x00, 0x77, 0xEE, 0x00,
    0x00, 0xCF, 0x3D, 0x00,
    0x11, 0x9E, 0x5A, 0x88,
    0x11, 0xF0, 0xF0, 0x88,
    0x33, 0xFE, 0xFA, 0x4C,
    0x33, 0xAF, 0x3C, 0xC4,
    0x23, 0x9E, 0x5A, 0x4C,
    0x33, 0xAF, 0x3C, 0xC4,
    0x23, 0x9E, 0x5A, 0x4C,
    0x33, 0xAF, 0x3C, 0xC4,
    0x23, 0xDA, 0x5A, 0x4C,
    0x33, 0xFE, 0xF7, 0xCC,
    0x33, 0x11, 0x88, 0xCC,
    0x57, 0x11, 0x88, 0xAE,
    0x57, 0x11, 0x88, 0xAE,
    0xFF, 0x11, 0x88, 0xFF}
};

const u8 powerup[4][64] = {
  {0xFF, 0xFF, 0xFF, 0xFF, // Shield
    0x88, 0x00, 0x00, 0x01,
    0xA8, 0xA0, 0xA0, 0xA1,
    0x98, 0x98, 0x41, 0x41,
    0xA8, 0xCC, 0x83, 0x21,
    0x98, 0xFF, 0x0F, 0x41,
    0xA8, 0xFC, 0xC3, 0x21,
    0x98, 0xFC, 0x0F, 0x41,
    0xA8, 0xFC, 0xC3, 0x21,
    0x98, 0xFF, 0xC3, 0x41,
    0xA8, 0xFC, 0xC3, 0x21,
    0x98, 0x77, 0x0E, 0x41,
    0xA8, 0xB3, 0x0C, 0xA1,
    0x98, 0x51, 0x18, 0x41,
    0xA8, 0xA0, 0xA0, 0xA1,
    0x0F, 0x0F, 0x0F, 0x0F},
  {0xFF, 0xFF, 0xFF, 0xFF, // Energy
    0x88, 0x00, 0x00, 0x01,
    0xA8, 0xA0, 0xA0, 0xA1,
    0x98, 0x50, 0x50, 0x41,
    0xA8, 0xB3, 0xEE, 0xA1,
    0x98, 0x62, 0x22, 0x41,
    0xA8, 0xFF, 0xFF, 0xA9,
    0x98, 0xFF, 0xFF, 0x09,
    0xA8, 0xFF, 0xF7, 0x29,
    0x98, 0xFE, 0xF3, 0x09,
    0xA8, 0xFF, 0xF7, 0x29,
    0x98, 0xFF, 0xFF, 0x09,
    0xA8, 0x0F, 0x0F, 0x29,
    0x98, 0x00, 0x00, 0x01,
    0xA8, 0xA0, 0xA0, 0xA1,
    0x0F, 0x0F, 0x0F, 0x0F},
  {0xFF, 0xFF, 0xFF, 0xFF, // Bullets
    0x88, 0x00, 0x00, 0x01,
    0xA8, 0xA0, 0xA0, 0xA1,
    0x98, 0x50, 0x50, 0x41,
    0xAB, 0xFF, 0xCE, 0xA1,
    0xAB, 0xFF, 0xFF, 0x8D,
    0x9A, 0x0F, 0x0E, 0x01,
    0x88, 0x00, 0x00, 0x41,
    0xA8, 0xA0, 0xA0, 0xA1,
    0xAB, 0xFF, 0xDE, 0x41,
    0xAB, 0xFF, 0xFF, 0xAD,
    0x9A, 0x0F, 0x0E, 0x01,
    0xA8, 0x80, 0x00, 0xA1,
    0x98, 0x50, 0x50, 0x41,
    0xA8, 0xA0, 0xA0, 0xA1,
    0x8F, 0x0F, 0x0F, 0x0F},
  {0x7F, 0xFF, 0xFF, 0xEF, // Normal
    0xB4, 0xF0, 0xF0, 0xD2,
    0xC8, 0x00, 0x00, 0xB4,
    0xC9, 0x0F, 0x1E, 0x3E,
    0xC8, 0x00, 0x21, 0x3A,
    0xC9, 0x0F, 0x4B, 0x32,
    0xC8, 0x00, 0x86, 0x32,
    0xC9, 0x1E, 0x0D, 0x3A,
    0xC8, 0x21, 0x08, 0x32,
    0xC9, 0x4B, 0x07, 0x3A,
    0xC8, 0x86, 0x00, 0x32,
    0xD8, 0x0D, 0x0F, 0x3A,
    0xE9, 0x08, 0x00, 0x32,
    0xCB, 0x07, 0x0F, 0x3A,
    0xBD, 0xFF, 0xFF, 0xDA,
    0x78, 0xF0, 0xF0, 0xE1}
};

const u8 explosion[22][64] = {
  {0x00, 0x77, 0xEE, 0x00,
    0x11, 0xFF, 0xFF, 0x88,
    0x33, 0xFF, 0xFF, 0xCC,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0x33, 0xFF, 0xFF, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00},
  {0x00, 0x77, 0xEE, 0x00,
    0x11, 0xFF, 0xFF, 0x88,
    0x33, 0xFF, 0xFF, 0xCC,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0x33, 0xFF, 0xFF, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00},
  {
    0x00, 0x77, 0xEE, 0x00,
    0x11, 0xFF, 0xFF, 0x88,
    0x33, 0xFF, 0xFF, 0xCC,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x3F, 0xFF,
    0xFF, 0xFF, 0x3F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0x33, 0xFF, 0xFF, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00
  },
  {
    0x00, 0x77, 0xEE, 0x00,
    0x11, 0xFF, 0xFF, 0x88,
    0x33, 0xFF, 0xFF, 0xCC,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0xFF, 0xFF, 0x3F, 0xFF,
    0xFF, 0xEF, 0x1F, 0xFF,
    0xFF, 0xEF, 0x1F, 0xFF,
    0xFF, 0xFF, 0x3F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0x33, 0xFF, 0xFF, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00
  },
  { 0x00, 0x77, 0xEE, 0x00,
    0x11, 0xFF, 0xFF, 0x88,
    0x33, 0xFF, 0xFF, 0xCC,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0x3F, 0xEE,
    0xFF, 0xEF, 0x1F, 0xFF,
    0xFF, 0xCF, 0x0F, 0xFF,
    0xFF, 0xCF, 0x0F, 0xFF,
    0xFF, 0xEF, 0x1F, 0xFF,
    0xFF, 0xFF, 0x3F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0x33, 0xFF, 0xFF, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00},
  {
    0x00, 0x77, 0xEE, 0x00,
    0x11, 0xFF, 0xFF, 0x88,
    0x33, 0xFF, 0xFF, 0xCC,
    0x77, 0xEF, 0x1F, 0xEE,
    0x77, 0xCF, 0x0F, 0xEE,
    0xFF, 0x8F, 0x0F, 0x7F,
    0xFF, 0x8F, 0x0F, 0x7F,
    0xFF, 0x8F, 0x0F, 0x7F,
    0xFF, 0x8F, 0x0F, 0x7F,
    0xFF, 0xCF, 0x0F, 0xFF,
    0xFF, 0xEF, 0x1F, 0xFF,
    0x77, 0xFF, 0xFF, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0x33, 0xFF, 0xFF, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00
  },
  {
    0x00, 0x77, 0xEE, 0x00,
    0x11, 0xFF, 0xFF, 0x88,
    0x33, 0xEF, 0x1F, 0xCC,
    0x77, 0xCF, 0x0F, 0xEE,
    0x77, 0x8F, 0x0F, 0x6E,
    0xFF, 0x0F, 0x0F, 0x3F,
    0xFF, 0x0F, 0x0F, 0x3F,
    0xFF, 0x1E, 0x0F, 0x3F,
    0xFF, 0x0F, 0x0F, 0x3F,
    0xFF, 0x8F, 0x0F, 0x7F,
    0xFF, 0xCF, 0x0F, 0xFF,
    0x77, 0xEF, 0x1F, 0xEE,
    0x77, 0xFF, 0xFF, 0xEE,
    0x33, 0xFF, 0xFF, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00
  },
  {
    0x00, 0x77, 0xEE, 0x00,
    0x11, 0xCF, 0x0F, 0x88,
    0x33, 0x8F, 0x0F, 0x4C,
    0x77, 0x0F, 0x0F, 0x2E,
    0x67, 0x0F, 0x0F, 0x0E,
    0xEF, 0x0F, 0x0F, 0x1F,
    0xEF, 0x3C, 0x0F, 0x1F,
    0xEF, 0x3C, 0x0F, 0x1F,
    0xEF, 0x0F, 0x0F, 0x1F,
    0xEF, 0x0F, 0x0F, 0x1F,
    0xFF, 0x0F, 0x0F, 0x3F,
    0x77, 0x8F, 0x0F, 0x6E,
    0x77, 0xCF, 0x0F, 0xEE,
    0x33, 0xFF, 0xFF, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00
  },
  {
    0x00, 0x47, 0x0E, 0x00,
    0x11, 0x8F, 0x0F, 0x08,
    0x33, 0x0F, 0x0F, 0x0C,
    0x67, 0x0F, 0x0F, 0x0E,
    0x47, 0x0F, 0x0F, 0x0E,
    0xCF, 0x3C, 0x0F, 0x0F,
    0xCF, 0x78, 0x87, 0x0F,
    0xCF, 0x78, 0x87, 0x0F,
    0xCF, 0x3C, 0x0F, 0x0F,
    0xCF, 0x0F, 0x0F, 0x0F,
    0xEF, 0x0F, 0x0F, 0x1F,
    0x77, 0x0F, 0x0F, 0x2E,
    0x77, 0x8F, 0x0F, 0x6E,
    0x33, 0xCF, 0x0F, 0xCC,
    0x11, 0xFF, 0xFF, 0x88,
    0x00, 0x77, 0xEE, 0x00
  },
  {
    0x00, 0x07, 0x0E, 0x00,
    0x11, 0x0F, 0x0F, 0x08,
    0x23, 0x0F, 0x0F, 0x0C,
    0x47, 0x0F, 0x0F, 0x0E,
    0x07, 0x3C, 0x0F, 0x0E,
    0x8F, 0x78, 0x87, 0x0F,
    0x8F, 0xF0, 0xC3, 0x0F,
    0x8F, 0xF0, 0xC3, 0x0F,
    0x8F, 0x78, 0x87, 0x0F,
    0x8F, 0x3C, 0x0F, 0x0F,
    0x8F, 0x0F, 0x0F, 0x0F,
    0x47, 0x0F, 0x0F, 0x0E,
    0x67, 0x0F, 0x0F, 0x2E,
    0x33, 0x0F, 0x0F, 0x4C,
    0x11, 0x8F, 0x0F, 0x88,
    0x00, 0x77, 0xEE, 0x00
  },
  {
    0x00, 0x07, 0x0E, 0x00,
    0x01, 0x0F, 0x0F, 0x08,
    0x03, 0x0F, 0x0F, 0x0C,
    0x07, 0x78, 0x87, 0x0E,
    0x07, 0xF0, 0xC3, 0x0E,
    0x1E, 0xF0, 0xE1, 0x0F,
    0x1E, 0xF0, 0xE1, 0x0F,
    0x1E, 0xF0, 0xE1, 0x0F,
    0x1E, 0xF0, 0xE1, 0x0F,
    0x0F, 0xF0, 0xC3, 0x0F,
    0x0F, 0x78, 0x87, 0x0F,
    0x07, 0x0F, 0x0F, 0x0E,
    0x47, 0x0F, 0x0F, 0x0E,
    0x23, 0x0F, 0x0F, 0x0C,
    0x11, 0x0F, 0x0F, 0x08,
    0x00, 0x07, 0x0E, 0x00
  },
  {
    0x00, 0x07, 0x0E, 0x00,
    0x01, 0x0F, 0x0F, 0x08,
    0x03, 0x78, 0x87, 0x0C,
    0x07, 0xF0, 0xC3, 0x0E,
    0x16, 0xF0, 0xE1, 0x0E,
    0x3C, 0xF0, 0xF0, 0x0F,
    0x3C, 0xF0, 0xF0, 0x0F,
    0x3C, 0xF0, 0xF0, 0x0F,
    0x3C, 0xF0, 0x70, 0x0F,
    0x1E, 0xF0, 0xE1, 0x0F,
    0x0F, 0xF0, 0xC3, 0x0F,
    0x07, 0x78, 0x87, 0x0E,
    0x07, 0x0F, 0x0F, 0x0E,
    0x03, 0x0F, 0x0F, 0x0C,
    0x01, 0x0F, 0x0F, 0x08,
    0x00, 0x07, 0x0E, 0x00
  },
  {
    0x00, 0x07, 0x0E, 0x00,
    0x01, 0xF0, 0xC3, 0x08,
    0x12, 0xF0, 0xE1, 0x0C,
    0x34, 0xF0, 0xF0, 0x0E,
    0x70, 0xF0, 0xF0, 0x86,
    0x78, 0xF0, 0xF0, 0x87,
    0x78, 0xF0, 0xF0, 0x87,
    0x78, 0xF0, 0xF0, 0x87,
    0x78, 0xF0, 0x30, 0x87,
    0x78, 0xF0, 0x30, 0x87,
    0x3C, 0xF0, 0xF0, 0x0F,
    0x16, 0xF0, 0xE1, 0x0E,
    0x07, 0xF0, 0xC3, 0x0E,
    0x03, 0x0F, 0x0F, 0x0C,
    0x01, 0x0F, 0x0F, 0x08,
    0x00, 0x07, 0x0E, 0x00
  },
  {
    0x00, 0x70, 0xC2, 0x00,
    0x10, 0xF0, 0xE1, 0x08,
    0x30, 0xF0, 0xF0, 0x0C,
    0x70, 0xF0, 0xF0, 0x86,
    0x70, 0xF0, 0xF0, 0xC2,
    0xF0, 0xF0, 0xF0, 0xC3,
    0xF0, 0xF0, 0xF0, 0xC3,
    0xF0, 0xF0, 0x30, 0xC3,
    0xF0, 0xE0, 0x10, 0xC3,
    0xF0, 0xE0, 0x10, 0xC3,
    0x78, 0xF0, 0x30, 0x87,
    0x34, 0xF0, 0xF0, 0x0E,
    0x16, 0xF0, 0xE1, 0x0E,
    0x03, 0xF0, 0xC3, 0x0C,
    0x01, 0x0F, 0x0F, 0x08,
    0x00, 0x07, 0x0E, 0x00
  },
  {
    0x00, 0x70, 0xE0, 0x00,
    0x10, 0xF0, 0xF0, 0x08,
    0x30, 0xF0, 0xF0, 0x84,
    0x70, 0xF0, 0xF0, 0xC2,
    0x70, 0xF0, 0xF0, 0xE0,
    0xF0, 0xF0, 0xF0, 0xE1,
    0xF0, 0xF0, 0x30, 0xE1,
    0xF0, 0xE0, 0x10, 0xE1,
    0xF0, 0xC0, 0x00, 0xE1,
    0xF0, 0xC0, 0x00, 0xE1,
    0xF0, 0xE0, 0x10, 0xC3,
    0x70, 0xF0, 0x30, 0x86,
    0x34, 0xF0, 0xF0, 0x0E,
    0x12, 0xF0, 0xE1, 0x0C,
    0x01, 0xF0, 0xC3, 0x08,
    0x00, 0x07, 0x0E, 0x00
  },
  {
    0x00, 0x70, 0xE0, 0x00,
    0x10, 0xF0, 0xF0, 0x80,
    0x30, 0xF0, 0xF0, 0xC0,
    0x70, 0xF0, 0xF0, 0xE0,
    0x70, 0xF0, 0xF0, 0xE0,
    0xF0, 0xE0, 0x10, 0xF0,
    0xF0, 0xC0, 0x00, 0xF0,
    0xF0, 0x80, 0x00, 0x70,
    0xF0, 0x80, 0x00, 0x70,
    0xF0, 0x80, 0x00, 0x70,
    0xF0, 0x80, 0x00, 0x61,
    0x70, 0xC0, 0x00, 0xE0,
    0x70, 0xE0, 0x10, 0xC2,
    0x30, 0xF0, 0xF0, 0x84,
    0x10, 0xF0, 0xF0, 0x08,
    0x00, 0x70, 0xC2, 0x00
  },
  {
    0x00, 0x70, 0xE0, 0x00,
    0x10, 0xF0, 0xF0, 0x80,
    0x30, 0xF0, 0xF0, 0xC0,
    0x70, 0xF0, 0xF0, 0xE0,
    0x70, 0xE0, 0x10, 0xE0,
    0xF0, 0xC0, 0x00, 0xF0,
    0xF0, 0x80, 0x00, 0x70,
    0xF0, 0x00, 0x00, 0x30,
    0xF0, 0x00, 0x00, 0x30,
    0xF0, 0x00, 0x00, 0x30,
    0xF0, 0x00, 0x00, 0x30,
    0x70, 0x80, 0x00, 0x60,
    0x70, 0xC0, 0x00, 0xE0,
    0x30, 0xE0, 0x10, 0xC0,
    0x10, 0xF0, 0xF0, 0x80,
    0x00, 0x70, 0xE0, 0x00
  },
  {
    0x00, 0x70, 0xE0, 0x00,
    0x10, 0xF0, 0xF0, 0x80,
    0x30, 0xF0, 0xF0, 0xC0,
    0x70, 0xC0, 0x00, 0xE0,
    0x70, 0x80, 0x00, 0x60,
    0xF0, 0x00, 0x00, 0x30,
    0xE0, 0x00, 0x00, 0x10,
    0xE0, 0x00, 0x00, 0x10,
    0xE0, 0x00, 0x00, 0x10,
    0xE0, 0x00, 0x00, 0x10,
    0xE0, 0x00, 0x00, 0x10,
    0x60, 0x00, 0x00, 0x00,
    0x70, 0x00, 0x00, 0x20,
    0x30, 0x80, 0x00, 0x40,
    0x10, 0xC0, 0x00, 0x80,
    0x00, 0x70, 0xE0, 0x00
  },
  {
    0x00, 0x70, 0xE0, 0x00,
    0x10, 0xF0, 0xF0, 0x80,
    0x30, 0xC0, 0x00, 0xC0,
    0x70, 0x80, 0x00, 0x60,
    0x70, 0x00, 0x00, 0x20,
    0xE0, 0x00, 0x00, 0x10,
    0xC0, 0x00, 0x00, 0x00,
    0xC0, 0x00, 0x00, 0x00,
    0xC0, 0x00, 0x00, 0x00,
    0xC0, 0x00, 0x00, 0x00,
    0xC0, 0x00, 0x00, 0x00,
    0x40, 0x00, 0x00, 0x00,
    0x60, 0x00, 0x00, 0x00,
    0x30, 0x00, 0x00, 0x00,
    0x10, 0x80, 0x00, 0x00,
    0x00, 0x40, 0x00, 0x00
  },
  {
    0x00, 0x70, 0xE0, 0x00,
    0x10, 0x80, 0x00, 0x80,
    0x30, 0x00, 0x00, 0x40,
    0x60, 0x00, 0x00, 0x20,
    0x40, 0x00, 0x00, 0x00,
    0x80, 0x00, 0x00, 0x00,
    0x80, 0x00, 0x00, 0x00,
    0x80, 0x00, 0x00, 0x00,
    0x80, 0x00, 0x00, 0x00,
    0x80, 0x00, 0x00, 0x00,
    0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x40, 0x00, 0x00, 0x00,
    0x20, 0x00, 0x00, 0x00,
    0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
  },
  {
    0x00, 0x00, 0x00, 0x00,
    0x10, 0x00, 0x00, 0x00,
    0x20, 0x00, 0x00, 0x00,
    0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
  },
  {
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00
  }
};

const u8 topleft[560] = {
  0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0x88, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0xEF, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x00, 0xFE, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0xED, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0xEF, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x00, 0x7F, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x7F, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A,
  0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
  0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x00, 0x00, 0x00,
  0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x00, 0x00, 0x00,
  0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x00, 0x00, 0x00
};


const u8 topcenter[1120] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xC8, 0x00, 0x88, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xC0, 0x00, 0xEF, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xFD, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x00, 0xFE, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xF8, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xC8, 0x00, 0xED, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xFD, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xC8, 0x00, 0xEF, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xC0, 0x00, 0x67, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x00, 0x22, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x00, 0x7F, 0x88, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xC8, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xC0, 0x00, 0x7F, 0x88, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
  0x0F, 0x0F, 0x0F, 0x0F,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A,
  0x3A, 0x3A, 0x3A, 0x3A,
  0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
  0x7E, 0x7E, 0x7E, 0x7E,
  0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
  0x78, 0x78, 0x78, 0x78,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x20, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x80,
  0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x78, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x10, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x40,
  0x3A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x78, 0x00, 0x00, 0x00
};


const u8 topright[560] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x00, 0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13,
  0x00, 0xFF, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x00, 0xFD, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x00, 0xF8, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x00, 0xFD, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13,
  0x00, 0x7F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12,
  0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
  0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A,
  0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
  0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
  0x00, 0x00, 0x00, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A,
  0x00, 0x00, 0x00, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
  0x00, 0x00, 0x00, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78
};

const u8 bottomleft[320] = {
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x01, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x01, 0x0F, 0x08, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x03, 0x0F, 0x80, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x83, 0x1E, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x96, 0xB4, 0xA0, 0x00, 0x00, 0x07, 0x00,
  0xF0, 0x1E, 0xF0, 0x52, 0xC0, 0x03, 0x0F, 0x3C,
  0xC3, 0x3C, 0xA0, 0x1E, 0xA0, 0x07, 0x0F, 0x2C,
  0xD2, 0x78, 0x41, 0x1E, 0x41, 0x0F, 0x4B, 0x78,
  0xD2, 0xA0, 0x83, 0x2C, 0x83, 0x0F, 0x96, 0xA0,
  0xF0, 0x50, 0x07, 0x78, 0x52, 0x1E, 0x96, 0xD0,
  0xA0, 0xA0, 0x0F, 0xE0, 0x1E, 0x96, 0xE0, 0xA0,
  0x50, 0x41, 0x0F, 0x49, 0x3C, 0xF0, 0xD0, 0x50,
  0xE0, 0x83, 0xB4, 0xA1, 0xF0, 0xF0, 0xA0, 0xA0,
  0xD0, 0x1E, 0xF0, 0x70, 0xF0, 0xF0, 0x70, 0x50,
  0xB0, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0xA0, 0xA0,
  0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xD0, 0x50, 0x50,
  0xF0, 0xF0, 0xF0, 0xF0, 0xB0, 0xA0, 0xA0, 0xA0,
  0xF0, 0xF0, 0xF0, 0xF0, 0x50, 0x50, 0x50, 0x50,
  0xF0, 0xF0, 0xF0, 0xF0, 0xB0, 0xA0, 0xA0, 0xA0,
  0xF0, 0xD0, 0xD0, 0x50, 0x70, 0x50, 0x50, 0x50,
  0xF0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0
};

const u8 bottom1[640] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3C, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x78, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF0, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xB4, 0xA0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x3C, 0x50, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x3C, 0xA0, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x58, 0x50, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0xA0, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1E, 0xD0, 0x50, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2D, 0xE0, 0xA1, 0x68, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3C, 0x58, 0x41, 0x78, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x2D, 0xE0, 0x87, 0xE0, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x78, 0xD0, 0x16, 0xD0, 0x00, 0x00, 0x07, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x2D, 0xF0, 0xA1, 0x3C, 0xA4, 0x04, 0x00, 0x07, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x06, 0x00, 0x03, 0x5A, 0xD0, 0x41, 0x1E, 0x58, 0x04, 0x00, 0x07, 0xC0, 0x00, 0x00,
  0x00, 0x0F, 0x0F, 0x09, 0x0F, 0xA5, 0xE0, 0x83, 0x1E, 0x68, 0x68, 0x00, 0x0F, 0xA0, 0xC0, 0x00,
  0x4B, 0x0F, 0x0F, 0x0F, 0x1E, 0x3C, 0xD0, 0x07, 0x96, 0x58, 0x48, 0x01, 0x0F, 0xD0, 0xE0, 0x50,
  0x87, 0x87, 0x87, 0xA5, 0x0F, 0x2D, 0xA0, 0x1E, 0x0F, 0x69, 0x68, 0x03, 0x1E, 0xB0, 0xB0, 0xB0,
  0x5A, 0x78, 0x5A, 0x78, 0x0F, 0xF0, 0xC1, 0x4B, 0x1E, 0x4B, 0x58, 0x16, 0x3C, 0x70, 0xD0, 0x50,
  0xB4, 0xF0, 0xF0, 0xE1, 0x3C, 0xF0, 0x92, 0xF0, 0xB4, 0x0F, 0xA0, 0x3C, 0x3C, 0xD2, 0xA0, 0xA0,
  0x78, 0xF0, 0xF0, 0xC3, 0xF0, 0xF0, 0x43, 0xF0, 0xF0, 0x0F, 0x50, 0x2D, 0x3C, 0x07, 0x58, 0x50,
  0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0xE0, 0xB0, 0xF0, 0xE1, 0x1E, 0xA1, 0x69, 0x2C, 0x96, 0xA0, 0xA0,
  0xF0, 0xF0, 0xF0, 0x70, 0xD0, 0xD0, 0xF0, 0xF0, 0xF0, 0xB4, 0x16, 0x69, 0x58, 0x16, 0x50, 0x50,
  0xF0, 0xF0, 0xE0, 0xA0, 0xB0, 0xB0, 0xF0, 0xF0, 0xF0, 0xF0, 0xB4, 0xF0, 0xA0, 0xE0, 0xA0, 0xA0,
  0x50, 0x70, 0x70, 0xF0, 0x70, 0x50, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xD0, 0xD0, 0xF0, 0x50,
  0xA0, 0xA0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xA0, 0xA0,
  0x50, 0xD0, 0x50, 0xF0, 0x50, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xD0, 0x50, 0x50,
  0xF0, 0xA0, 0xF0, 0xA0, 0xF0, 0xF0, 0xF0, 0xE0, 0xF0, 0xF0, 0xE0, 0xF0, 0xF0, 0xA0, 0xF0, 0xE0,
  0xF0, 0x50, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0x50, 0xF0, 0xF0, 0x70, 0x70, 0xD0, 0x50, 0x50, 0xD0,
  0xB0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0xB0, 0xE0, 0xE0, 0xE0, 0xE0, 0xA0, 0xA0, 0xA0, 0xA0,
  0xF0, 0xF0, 0xF0, 0xF0, 0xD0, 0xF0, 0x50, 0x50, 0xD0, 0x70, 0x70, 0xD0, 0x50, 0x50, 0x50, 0x50,
  0xF0, 0xF0, 0xA0, 0xF0, 0xB0, 0xA0, 0xA0, 0xB0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0
};

const u8 bottom2[640] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5A, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x2D, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5A, 0x80, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xB4, 0xC0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x4B, 0xC0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xA5, 0xB0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5A, 0xD0, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1E, 0xA1, 0x78, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x00, 0x00, 0x07, 0x1E, 0xC1, 0x78, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0x80, 0x00, 0x0F, 0x3C, 0xA1, 0x78, 0x80, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0x48, 0x01, 0x0F, 0x1E, 0xC1, 0x3C, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x0F, 0xE0, 0x03, 0x2D, 0x3C, 0x83, 0x3C, 0x80, 0x07, 0x3C, 0x00, 0x00, 0x06, 0x00,
  0x01, 0x1A, 0x1E, 0xF0, 0x03, 0x1E, 0x78, 0xD2, 0x78, 0x43, 0x0F, 0x78, 0x00, 0x00, 0x06, 0x08,
  0x03, 0x2D, 0x2D, 0xF0, 0x87, 0x3C, 0x3C, 0x92, 0xE0, 0xA1, 0x0F, 0xF0, 0x00, 0x00, 0x2D, 0xC0,
  0x0F, 0x78, 0xD2, 0xF0, 0x96, 0x78, 0x78, 0x16, 0xD0, 0x43, 0x1E, 0xD0, 0x80, 0x00, 0x5A, 0xF0,
  0x0F, 0xF0, 0x87, 0xF0, 0x96, 0x78, 0x68, 0xB4, 0xA0, 0x83, 0x3C, 0xE0, 0x80, 0x01, 0x2D, 0x68,
  0x1E, 0xF0, 0x1E, 0xF0, 0x1E, 0x78, 0x78, 0x34, 0xD0, 0x07, 0x78, 0xF0, 0x40, 0x03, 0x4B, 0x78,
  0x0F, 0xF0, 0x3C, 0xE1, 0x1E, 0x78, 0x68, 0x3C, 0xA0, 0x87, 0x78, 0xE0, 0x80, 0x03, 0x87, 0xE0,
  0x87, 0xE1, 0x78, 0xE1, 0x1E, 0x3C, 0xF0, 0xB4, 0x50, 0x1E, 0x78, 0xD0, 0x40, 0x12, 0x0F, 0xD0,
  0x87, 0xE1, 0x1E, 0xC3, 0x4B, 0x3C, 0xB0, 0xF0, 0xA1, 0x0F, 0x78, 0xA0, 0x80, 0x07, 0xB4, 0xA0,
  0x96, 0xE1, 0x3C, 0x96, 0xC3, 0x78, 0x50, 0xF0, 0x43, 0x0F, 0x78, 0xD0, 0x40, 0x16, 0x3C, 0xD0,
  0x0F, 0x78, 0x5A, 0x96, 0xC3, 0xF0, 0xE0, 0xE0, 0x87, 0xE1, 0x78, 0xA0, 0xA0, 0x25, 0x1E, 0xA0,
  0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xD0, 0xF0, 0x34, 0xE1, 0xF0, 0xD0, 0x40, 0x1E, 0x1E, 0x50,
  0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xA0, 0xB0, 0xB4, 0xF0, 0xA0,
  0xD0, 0x70, 0xF0, 0xF0, 0xF0, 0xF0, 0xD0, 0xF0, 0xF0, 0xF0, 0xF0, 0x70, 0x70, 0xF0, 0xF0, 0x50,
  0xA0, 0xF0, 0xB0, 0xF0, 0xF0, 0xF0, 0xE0, 0xF0, 0xF0, 0xF0, 0xA0, 0xE0, 0xF0, 0xF0, 0xE0, 0xE0,
  0x50, 0xD0, 0xF0, 0xD0, 0xD0, 0xF0, 0xD0, 0x50, 0xF0, 0x50, 0xF0, 0xF0, 0xF0, 0xF0, 0x70, 0x50,
  0xF0, 0xF0, 0xE0, 0xA0, 0xF0, 0xB0, 0xA0, 0xA0, 0xE0, 0xB0, 0xF0, 0xF0, 0xF0, 0xE0, 0xE0, 0xA0,
  0x50, 0xF0, 0xD0, 0x50, 0xF0, 0xF0, 0x50, 0xD0, 0x50, 0xF0, 0xF0, 0xF0, 0xF0, 0xD0, 0xF0, 0xD0,
  0xF0, 0xF0, 0xA0, 0xE0, 0xB0, 0xA0, 0xA0, 0xA0, 0xA0, 0xB0, 0xF0, 0xE0, 0xA0, 0xA0, 0xB0, 0xB0
};

const u8 bottom3[640] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x1E, 0xD0, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x0F, 0xA0, 0xF0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1E, 0xD0, 0xF0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3C, 0xA0, 0x87, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1E, 0xD0, 0xC3, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x2D, 0x2C, 0xB0, 0x87, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0F, 0x78, 0x14, 0x0F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x2D, 0x2D, 0x68, 0x2D, 0x1E, 0xA0, 0x80, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x78, 0x4B, 0x49, 0x0F, 0x1E, 0xD0, 0x90, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x21, 0x78, 0xC3, 0xA1, 0x0F, 0x3C, 0xA0, 0xF0, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x07, 0x78, 0x87, 0x49, 0x1E, 0x1E, 0xD0, 0xF0, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x0F, 0xF0, 0x87, 0x83, 0x3C, 0x1E, 0xA0, 0xF0, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x18, 0x1E, 0x3C, 0x1E, 0x07, 0x1E, 0xC3, 0xF0, 0xD2, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xE1, 0x0F, 0x3C, 0x4A, 0x87, 0xB4, 0xE1, 0xA0, 0xD2, 0xF0, 0x90, 0x00, 0x00,
  0x00, 0x03, 0x1E, 0xF0, 0x0F, 0x78, 0x0F, 0x0F, 0x2D, 0xF0, 0xF0, 0x87, 0xF0, 0xD0, 0x00, 0x00,
  0x03, 0x0F, 0xB4, 0xF0, 0x1E, 0xF0, 0x87, 0x0F, 0x3C, 0xF0, 0xE0, 0x87, 0xB0, 0xB0, 0x80, 0x00,
  0x87, 0x1E, 0x1E, 0xF0, 0x3C, 0xF0, 0x87, 0x0F, 0x1E, 0xF0, 0xD0, 0x1E, 0x50, 0x70, 0xC0, 0x10,
  0x0F, 0xA5, 0x3C, 0xF0, 0x3C, 0xF0, 0x87, 0x87, 0x5A, 0xF0, 0xE1, 0x2C, 0xA0, 0xB0, 0xA0, 0x20,
  0x1E, 0x69, 0x78, 0xF0, 0x78, 0xF0, 0x1E, 0xA5, 0x5A, 0xF0, 0x41, 0x78, 0x50, 0xF0, 0xD0, 0x50,
  0x78, 0xE1, 0x78, 0x1E, 0xF0, 0xE0, 0x3C, 0xF0, 0x78, 0xE0, 0xB0, 0x78, 0xA0, 0xF0, 0xB0, 0xE0,
  0xF0, 0xC3, 0xE1, 0x14, 0xF0, 0xD0, 0xF0, 0xF0, 0xF0, 0xF0, 0x70, 0xD0, 0x50, 0xF0, 0x50, 0xD0,
  0xF0, 0xD2, 0xE0, 0xB0, 0xF0, 0xB0, 0xF0, 0xF0, 0xF0, 0xE0, 0xB0, 0xE0, 0xB0, 0xF0, 0xF0, 0xE0,
  0xF0, 0xF0, 0xD0, 0x70, 0xF0, 0x50, 0xF0, 0xF0, 0xF0, 0xD0, 0x70, 0x70, 0x70, 0xF0, 0x70, 0xD0,
  0xF0, 0xF0, 0xE0, 0xF0, 0xE0, 0xB0, 0xE0, 0xB0, 0xF0, 0xA0, 0xA0, 0xA0, 0xF0, 0xE0, 0xB0, 0xA0,
  0xD0, 0xF0, 0xD0, 0x70, 0xD0, 0x50, 0xD0, 0xD0, 0xF0, 0xD0, 0x50, 0x50, 0xF0, 0xF0, 0x70, 0x50,
  0xB0, 0xF0, 0xE0, 0xF0, 0xE0, 0xE0, 0xF0, 0xB0, 0xB0, 0xA0, 0xA0, 0xA0, 0xF0, 0xE0, 0xF0, 0xA0,
  0x70, 0xF0, 0x50, 0xF0, 0xD0, 0x50, 0xD0, 0x50, 0x70, 0xF0, 0x50, 0x50, 0xF0, 0x70, 0x70, 0x50,
  0xB0, 0xA0, 0xA0, 0xA0, 0xA0, 0xB0, 0xE0, 0xA0, 0xB0, 0xE0, 0xA0, 0xB0, 0xE0, 0xA0, 0xE0, 0xA0,
  0x70, 0xD0, 0x50, 0x70, 0x70, 0xF0, 0x50, 0x50, 0x50, 0xD0, 0x70, 0x50, 0x70, 0x50, 0x50, 0x50,
  0xB0, 0xA0, 0xB0, 0xB0, 0xB0, 0xA0, 0xA0, 0xA0, 0xA0, 0xE0, 0xA0, 0xA0, 0xB0, 0xA0, 0xA0, 0xA0,
  0x70, 0xD0, 0x50, 0x50, 0x70, 0x50, 0x70, 0xD0, 0x50, 0xD0, 0xF0, 0x70, 0xF0, 0x50, 0x50, 0x50,
  0xA0, 0xA0, 0xA0, 0xE0, 0xE0, 0xE0, 0xB0, 0xA0, 0xB0, 0xB0, 0xE0, 0xE0, 0xA0, 0xA0, 0xA0, 0xA0
};

const u8 bottomright[320] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2D,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5A,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x1E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x3C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x3C,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x07, 0x3C,
  0x00, 0x01, 0x08, 0x00, 0x00, 0x02, 0x0F, 0x3C,
  0x01, 0x0F, 0x08, 0x00, 0x00, 0x07, 0x0F, 0x3C,
  0x07, 0x0F, 0x2C, 0x00, 0x00, 0x07, 0x0F, 0x3C,
  0x0F, 0x0F, 0x78, 0x00, 0x00, 0x07, 0x78, 0x78,
  0x0F, 0x0F, 0x3C, 0xC0, 0x00, 0x0F, 0xF0, 0x78,
  0x0F, 0x0F, 0xF0, 0xC0, 0x00, 0x0F, 0xF0, 0x78,
  0x0F, 0x0F, 0xF0, 0xE0, 0x00, 0x0F, 0xE1, 0x78,
  0x0F, 0x1E, 0xF0, 0xF0, 0x01, 0x1E, 0xF0, 0x78,
  0x0F, 0x3C, 0xF0, 0xF0, 0x83, 0x3C, 0xE1, 0x78,
  0x0F, 0x3C, 0xC1, 0xF0, 0xC1, 0x78, 0xF0, 0xF0,
  0x0F, 0x78, 0xA0, 0x78, 0x83, 0x78, 0xB0, 0xE0,
  0x5A, 0x78, 0x05, 0x78, 0x96, 0xF0, 0x70, 0xF0,
  0xC3, 0x68, 0x87, 0xF0, 0xB4, 0xF0, 0xB0, 0xE0,
  0xE1, 0x78, 0x16, 0xF0, 0x70, 0xF0, 0x70, 0x50,
  0xE1, 0xE0, 0x1E, 0xE0, 0xF0, 0xE0, 0xA0, 0xA0,
  0x41, 0xD0, 0x3C, 0xD0, 0xF0, 0xD0, 0x50, 0xD0,
  0xB0, 0xE0, 0xB0, 0xB0, 0xA0, 0xA0, 0xA0, 0xA0,
  0x70, 0x50, 0x70, 0x50, 0x50, 0x50, 0x50, 0x50,
  0xA0, 0xA0, 0xF0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0
};

const u8 star1[3] = {
  0x40,
  0xA4,
  0x40,
};

const u8 star2[10] = {
  0x20, 0x00,
  0x02, 0x00,
  0xA7, 0x80,
  0x02, 0x00,
  0x20, 0x00
};

const u8 star3[10] = {
  0x20, 0x00,
  0x02, 0x00,
  0x87, 0x80,
  0x02, 0x00,
  0x20, 0x00
};

const u8 title[6048] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0C, 0x02, 0x00, 0x01, 0x0E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0C, 0x02, 0x0C, 0x05, 0x0C, 0x01, 0x0C, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x01, 0x04, 0x00, 0x03, 0x0A, 0x04, 0x03, 0x08, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xC0, 0x0B, 0x00, 0x06, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C, 0x04, 0x08, 0x01, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0x04, 0x0D, 0x08, 0x04,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x06, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x81, 0x06, 0x04, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x0D, 0x00, 0x04,
  0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x12, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x86, 0x06, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x25, 0x88, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0x00, 0x0C, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C, 0x01, 0x0E, 0x00, 0x02,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00, 0xF0,
  0xF0, 0xF0, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0x70, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x00, 0x21, 0x88, 0xAD, 0x00, 0x00, 0x03, 0x08, 0x04, 0x08, 0x00, 0x30, 0x0F,
  0x0F, 0x0F, 0x0F, 0x1E, 0x80, 0x00, 0x00, 0x87, 0x0F, 0x0F, 0x0F, 0x0F, 0x1E, 0x80, 0x00, 0x00,
  0x30, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C, 0x00, 0x00, 0x30, 0x0F, 0x0F, 0x0F, 0x0F, 0x1E, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x01, 0x29, 0x88, 0xAD, 0x01, 0x00, 0x0D, 0x00, 0x00, 0x06, 0x00, 0x43, 0xFF,
  0xFF, 0xFF, 0xFF, 0xEF, 0x48, 0x00, 0x10, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x48, 0x00, 0x00,
  0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0x00, 0x00, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0x03, 0x25, 0x88, 0xAD, 0x04, 0x09, 0x00, 0x00, 0x08, 0x02, 0x00, 0xB7, 0x00,
  0x00, 0x00, 0x00, 0x11, 0xAC, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x11, 0xAC, 0x00, 0x00,
  0xB7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x00, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x11, 0xAC,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x00, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xE0, 0x02, 0x03, 0x12, 0x4C, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x10,
  0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x09, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x1E, 0x80, 0x04, 0x14, 0x4C, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x10,
  0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x00, 0x04, 0x29, 0x88, 0x33, 0xFF, 0xFF, 0xFF, 0xEF, 0x4A, 0x02, 0x21, 0x88, 0x33,
  0xFF, 0xFF, 0xFF, 0x88, 0x23, 0x80, 0x10, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x23, 0x80, 0x21,
  0x88, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0x00, 0x21, 0x88, 0x33, 0xFF, 0xFF, 0xFF, 0x88, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0x09, 0x00, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x11, 0xAC, 0x00, 0x21, 0x88, 0x47,
  0x0F, 0x0F, 0x0F, 0x4C, 0x23, 0x80, 0x08, 0x87, 0x0F, 0x0F, 0x0F, 0x0F, 0x4C, 0x23, 0x80, 0x21,
  0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C, 0x00, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x4C, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x01, 0x04, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x01, 0x21, 0x88, 0xBC,
  0xF0, 0xF0, 0xF0, 0xA6, 0x23, 0x80, 0x00, 0x70, 0xF0, 0xF0, 0xF0, 0xF0, 0xA6, 0x23, 0x80, 0x21,
  0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xF0, 0xC0, 0x00, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xA6, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x01, 0x04, 0x01, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x14, 0xA6, 0x23, 0x80, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xA6, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xA6, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
  0x00, 0x09, 0x00, 0x02, 0x03, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x23, 0x80, 0x21, 0x88, 0xAD,
  0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x30, 0x0F, 0x0F, 0x0F, 0x0F, 0x4C, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xA6, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0E, 0x0E, 0x08, 0x06, 0x34, 0x0F, 0x0F, 0x0F, 0x0F, 0x4C, 0x23, 0x80, 0x21, 0x88, 0xAD,
  0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xA6, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x0E, 0x08, 0x04, 0x0C, 0xF0, 0xF0, 0xF0, 0xF0, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xA6, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x08, 0x03, 0x00, 0x09, 0x0D, 0x02, 0x00, 0x00, 0x01, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xA6, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x0E, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x04, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC,
  0x00, 0x08, 0x00, 0xA6, 0x23, 0x80, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x4C, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x0F, 0x00, 0x09, 0x00, 0x04, 0x00, 0x01, 0x03, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x21, 0x88, 0x33, 0xFF, 0xFF, 0xFF, 0x88, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0x33, 0xFF, 0xFF, 0xFF, 0x88, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x08, 0x00, 0x05, 0x00, 0x00, 0x08, 0x08, 0x0A, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x06, 0xA6, 0x23, 0x80, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x4C, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x03, 0x00, 0x00, 0x02, 0x08, 0x06, 0x08, 0x02, 0x00, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xA6, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x03, 0x00, 0x01, 0x03, 0x00, 0x06, 0x00, 0x01, 0x00, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x11, 0xAC,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x03, 0x00, 0x06, 0x0B, 0x00, 0x04, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x08, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0x33, 0xFF, 0xFF, 0xFF, 0xEF, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x07, 0x00, 0x09, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x25, 0x88, 0xAD,
  0x00, 0x01, 0x00, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x21,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x1E, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x06, 0x00, 0x09, 0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x29, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x61,
  0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0x05, 0x01, 0x06, 0x00, 0x70, 0xF0, 0xF0, 0xF0, 0xF0, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xBC,
  0xF0, 0xF0, 0xF0, 0xA6, 0x23, 0x80, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xA6, 0x23, 0x90, 0x6D,
  0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xF0, 0xC0, 0x00, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0, 0xF0, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x08, 0x00, 0x08, 0x00, 0x87, 0x0F, 0x0F, 0x0F, 0x0F, 0x4C, 0x23, 0x80, 0x21, 0x88, 0x47,
  0x0F, 0x0F, 0x0F, 0x4C, 0x23, 0x80, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x4C, 0x23, 0x80, 0x61,
  0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C, 0x00, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x06, 0x00, 0x08, 0x10, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x88, 0x23, 0x80, 0x21, 0x88, 0x33,
  0xFF, 0xFF, 0xFF, 0x88, 0x23, 0x80, 0x21, 0x88, 0x33, 0xFF, 0xFF, 0xFF, 0x88, 0x23, 0x80, 0x21,
  0x88, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0x00, 0x21, 0x88, 0x33, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x09, 0x00, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x21, 0x88, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x30,
  0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x06, 0x00, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x21, 0x88, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0x00, 0x10,
  0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x07, 0x00, 0x00, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00, 0x11, 0xAC, 0x00, 0x21, 0x88, 0x00,
  0x00, 0x00, 0x00, 0x11, 0xAC, 0x00, 0x00, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x11, 0xAC, 0x00, 0x00,
  0xB7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80, 0x00, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23,
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x02, 0x00, 0x10, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x48, 0x00, 0x21, 0x88, 0x77,
  0xFF, 0xFF, 0xFF, 0xEF, 0x48, 0x00, 0x00, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x48, 0x00, 0x00,
  0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0x00, 0x00, 0x43, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x06, 0x00, 0x00, 0x87, 0x0F, 0x0F, 0x0F, 0x0F, 0x1E, 0x80, 0x00, 0x21, 0x88, 0x8F,
  0x0F, 0x0F, 0x0F, 0x1E, 0x80, 0x00, 0x00, 0x30, 0x0F, 0x0F, 0x0F, 0x0F, 0x1E, 0x80, 0x00, 0x00,
  0x30, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C, 0x00, 0x00, 0x30, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x2C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x00, 0x05, 0x01, 0x00, 0x70, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0x00, 0x00, 0x21, 0x88, 0xBC,
  0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0x01, 0x0A, 0x07, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x04, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x10, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x50, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x10, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x20, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC,
  0x00, 0x00, 0x00, 0x80, 0x00, 0x30, 0xF0, 0xF0, 0xF0, 0xF0, 0x80, 0x00, 0x00, 0x10, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7F, 0x48,
  0x00, 0x00, 0x80, 0x80, 0x00, 0xC3, 0x0F, 0x0F, 0x0F, 0x0F, 0x68, 0x00, 0x00, 0x21, 0x2C, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x80,
  0x00, 0x10, 0x10, 0x00, 0x10, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x9E, 0x00, 0x00, 0x53, 0xDE, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x7F, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x10,
  0x00, 0x00, 0x10, 0x00, 0x21, 0xCC, 0x00, 0x00, 0x00, 0x00, 0x67, 0x80, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
  0x00, 0x20, 0x20, 0x00, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90,
  0x00, 0x10, 0x20, 0x00, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
  0x00, 0x30, 0x40, 0x00, 0xA6, 0x00, 0xFF, 0xFF, 0xFF, 0xEE, 0x00, 0xAC, 0x00, 0x53, 0xDE, 0x00,
  0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x00, 0xA6, 0x11, 0x0F, 0x0F, 0x0F, 0x1F, 0x00, 0xAC, 0x00, 0x21, 0x2C, 0x00,
  0x10, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x40, 0x80, 0x00, 0xA6, 0x23, 0xF0, 0xF0, 0xF0, 0xE1, 0x88, 0xAC, 0x00, 0x10, 0xC0, 0x00,
  0x21, 0xEF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x53, 0xDE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x40, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
  0x00, 0x10, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x10, 0xC0, 0x00,
  0x53, 0x11, 0x48, 0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x70, 0xF0, 0xF0, 0xF0, 0xF0,
  0xE0, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x70, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0x00,
  0x00, 0x00, 0x20, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
  0x10, 0x20, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x21, 0x2C, 0x00,
  0x53, 0x11, 0x48, 0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x87, 0x0F, 0x0F, 0x0F, 0x0F,
  0x1E, 0x80, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x10, 0x87, 0x0F, 0x0F, 0x0F, 0x0F, 0x1E, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x00,
  0x80, 0x40, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x53, 0xDE, 0x00,
  0x21, 0x99, 0x48, 0x00, 0x00, 0x00, 0x10, 0x4C, 0x56, 0x00, 0x10, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,
  0xEF, 0x48, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x21, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x80,
  0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x80, 0x80, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0xA6, 0x23, 0x80,
  0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x10, 0x4C, 0x56, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00,
  0x11, 0xAC, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x53, 0x88, 0x00, 0x00, 0x00, 0x00, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x20,
  0x10, 0x00, 0x00, 0x00, 0xA6, 0x23, 0xF0, 0xF0, 0xF0, 0xE1, 0x88, 0xAC, 0x00, 0xA6, 0x23, 0x80,
  0x10, 0x4C, 0xAC, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x56, 0x00, 0x21, 0x88, 0xAC, 0x00, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x80, 0x60,
  0x20, 0x00, 0x00, 0x00, 0xA6, 0x11, 0x0F, 0x0F, 0x0F, 0x1F, 0x00, 0xAC, 0x00, 0xA6, 0x23, 0x80,
  0x10, 0x4C, 0x56, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x21, 0x88, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x56, 0x00, 0x21, 0x88, 0xAC, 0x00, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
  0x40, 0x00, 0x00, 0x00, 0xA6, 0x00, 0xFF, 0xFF, 0xFF, 0xEE, 0x00, 0xAC, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0xA6, 0x56, 0x00, 0x00, 0x00, 0x53, 0x11, 0x48, 0x00, 0x10, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,
  0x88, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x11, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x10, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60,
  0x80, 0x00, 0x00, 0x00, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x53, 0x11, 0x48, 0x00, 0x00, 0x87, 0x0F, 0x0F, 0x0F, 0x0F,
  0x4C, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x23, 0x0F, 0x0F, 0x0F, 0x0F, 0x1E, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x40, 0x10, 0x00, 0x00, 0x10, 0x20, 0x40, 0x10, 0x00, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x53, 0x23, 0x80, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x70, 0xF0, 0xF0, 0xF0, 0xF0,
  0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x56, 0xF0, 0xF0, 0xF0, 0xF0, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00, 0x80, 0x00, 0x00, 0x10, 0x80, 0x00, 0x00, 0x40,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x80, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x53, 0x11, 0x48, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0,
  0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x56, 0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x40, 0x00, 0x00, 0x20, 0x40, 0x50, 0x10, 0x80,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x00, 0xFF, 0x88, 0x00, 0x77, 0x9E, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x21, 0x99, 0x48, 0x00, 0x10, 0x4C, 0x56, 0x00, 0x00, 0x00, 0x30, 0x0F, 0x0F, 0x0F, 0x0F,
  0x4C, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x23, 0x0F, 0x0F, 0x0F, 0x0F, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x20, 0x40, 0x80, 0x00, 0x40, 0xE0, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x11, 0x0F, 0x4C, 0x00, 0x8F, 0x68, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x21, 0x88, 0xAC, 0x00, 0x10, 0x4C, 0x56, 0x00, 0x00, 0x00, 0x43, 0xFF, 0xFF, 0xFF, 0xFF,
  0x88, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x11, 0xFF, 0xFF, 0xFF, 0xFF, 0x2C, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x40, 0x10, 0x00, 0x00, 0x30, 0x70, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0xF0, 0xB7, 0x00, 0x56, 0x80, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x10, 0x4C, 0xAC, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0xB7, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDE, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xC0, 0x10, 0x20, 0x80, 0x00, 0x90, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x43, 0x88, 0x23, 0x80, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x10, 0x4C, 0x56, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xC0, 0x00, 0x40, 0x10, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x30, 0x4C, 0x23, 0x80, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0xA6, 0x56, 0x00, 0x53, 0x11, 0x48, 0x00, 0x00, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x53, 0x88, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xF0, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0xA6, 0x11, 0x48, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0xA6, 0x23, 0x80, 0x53, 0x11, 0x48, 0x00, 0x00, 0x21, 0x88, 0x33, 0xFF, 0xFF, 0xFF,
  0x88, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x21, 0x7F, 0xFF, 0xFF, 0xFF, 0xCC, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x53, 0x00, 0xAC, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x53, 0x23, 0x80, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F,
  0x4C, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x10, 0x87, 0x0F, 0x0F, 0x0F, 0x2E, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x53, 0x00, 0x56, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x53, 0x11, 0x48, 0xA6, 0x23, 0x80, 0x00, 0x00, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0,
  0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x70, 0xF0, 0xF0, 0xF0, 0xD3, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x21, 0x88, 0x56, 0x00, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x21, 0x99, 0x58, 0x4C, 0x56, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00,
  0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x21, 0x88, 0x23, 0x80, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x21, 0x88, 0xBC, 0x4C, 0x56, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00,
  0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x10, 0x4C, 0x23, 0x80, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x10, 0x4C, 0xAD, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00,
  0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x10, 0x4C, 0x23, 0x80, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x10, 0x4C, 0x47, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00,
  0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x10, 0x4C, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0xA6, 0x57, 0x11, 0x48, 0x00, 0x00, 0x00, 0x21, 0x88, 0xBC, 0xF0, 0xF0, 0xF0,
  0xA6, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x30, 0xF0, 0xF0, 0xF0, 0xF0, 0xD3, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0xA6, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0xA6, 0x22, 0x11, 0x48, 0x00, 0x00, 0x00, 0x21, 0x88, 0x47, 0x0F, 0x0F, 0x0F,
  0x4C, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0x43, 0x0F, 0x0F, 0x0F, 0x0F, 0x2E, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0xA6, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x53, 0x00, 0x23, 0x80, 0x00, 0x00, 0x00, 0x21, 0x88, 0x33, 0xFF, 0xFF, 0xFF,
  0x88, 0x23, 0x80, 0x21, 0x88, 0xAC, 0x00, 0xB7, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x11, 0x48,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0xA6, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x53, 0x00, 0x23, 0x80, 0x00, 0x00, 0x00, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x56, 0x00, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0xA6, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x21, 0x88, 0x56, 0x00, 0x00, 0x00, 0x00, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x56, 0x00, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xA6, 0x23, 0x80, 0x00, 0x00, 0xA6, 0x11, 0x48, 0x00, 0xA6, 0x23, 0x80,
  0x00, 0x00, 0x00, 0x21, 0x88, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB7, 0x00, 0x00, 0x00, 0x00,
  0x11, 0xAC, 0x00, 0x21, 0x88, 0xAC, 0x10, 0x4C, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDE, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x53, 0xDE, 0x00, 0x00, 0x00, 0x53, 0xEF, 0x80, 0x00, 0x53, 0xDE, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x7F, 0xAC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0xFF, 0xFF, 0xFF, 0xFF,
  0xEF, 0x48, 0x00, 0x10, 0x7F, 0x48, 0x00, 0xB7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x2C, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x21, 0x2C, 0x00, 0x01, 0x00, 0x21, 0x1E, 0x00, 0x00, 0x21, 0x2C, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x87, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0F, 0x0F, 0x0F, 0x0F,
  0x1E, 0x80, 0x00, 0x00, 0x87, 0x80, 0x00, 0x43, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0xC0, 0x00, 0x00, 0x00, 0x10, 0xE0, 0x00, 0x00, 0x10, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x70, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0,
  0xE0, 0x01, 0x00, 0x00, 0x70, 0x00, 0x00, 0x30, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

u8 const countdown[5][240] = {// GO!
  {0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0C, 0x00, 0x00, 0x07, 0x0F, 0x08, 0x00, 0x07, 0x0F,
    0x0F, 0x38, 0xF0, 0xF0, 0x83, 0x0F, 0x70, 0xF0, 0x83, 0x0F,
    0x0F, 0x70, 0xF0, 0xF0, 0xC1, 0x0E, 0xF0, 0xF0, 0xC1, 0x0F,
    0x0E, 0xF0, 0x00, 0x00, 0x01, 0x1C, 0xC0, 0x00, 0xE0, 0x0F,
    0x0E, 0xE0, 0xFF, 0xFF, 0xCD, 0x38, 0xB3, 0xFF, 0x70, 0x07,
    0x0E, 0xF1, 0x00, 0x00, 0x03, 0x38, 0xC4, 0x00, 0xF8, 0x07,
    0x0E, 0xE0, 0x0F, 0x0F, 0x0F, 0x38, 0x83, 0x0F, 0x70, 0x07,
    0x0E, 0xE0, 0x08, 0x00, 0x03, 0x38, 0x83, 0x0F, 0x70, 0x07,
    0x0E, 0xE0, 0x70, 0xF0, 0xC1, 0x38, 0x83, 0x0F, 0x70, 0x07,
    0x0E, 0xE0, 0x54, 0xF0, 0xC1, 0x38, 0x83, 0x0F, 0x70, 0x07,
    0x0E, 0xE0, 0x2A, 0x10, 0xC1, 0x38, 0x83, 0x0F, 0x70, 0x07,
    0x0E, 0xE0, 0x1D, 0xFE, 0xC1, 0x38, 0x83, 0x0F, 0x70, 0x07,
    0x0E, 0xE0, 0x0E, 0x10, 0xC1, 0x38, 0x83, 0x0F, 0x70, 0x07,
    0x0E, 0xE0, 0x0F, 0x1C, 0xC1, 0x38, 0x83, 0x0F, 0x70, 0x07,
    0x0E, 0xF0, 0x00, 0x10, 0xC1, 0x18, 0xC0, 0x00, 0xE0, 0x07,
    0x0E, 0x70, 0xF0, 0xF0, 0xC1, 0x2A, 0xF0, 0xF0, 0xD1, 0x07,
    0x0E, 0xB8, 0xF0, 0xF0, 0x81, 0x1D, 0x70, 0xF0, 0xA2, 0x0F,
    0x0F, 0x44, 0x00, 0x00, 0x45, 0x0E, 0x88, 0x00, 0x45, 0x0F,
    0x0F, 0x3B, 0xFF, 0xFF, 0x8B, 0x0F, 0x77, 0xFF, 0x8B, 0x0F,
    0x0F, 0x0C, 0x00, 0x00, 0x07, 0x0F, 0x08, 0x00, 0x07, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F},
  {0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, // 1
    0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0x03, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x38, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x70, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0E, 0xF0, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0C, 0x10, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x1D, 0xFE, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0E, 0x10, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x1C, 0xC1, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0E, 0x10, 0xC0, 0x03, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x1C, 0xF0, 0xF0, 0xC1, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x1C, 0xF0, 0xF0, 0xC1, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0C, 0x00, 0x00, 0x01, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x1D, 0xFF, 0xFF, 0xCD, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F}, // 2
  {0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x70, 0xF0, 0xF0, 0xC1, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF0, 0xF0, 0xF0, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x10, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xFF, 0xFF, 0xEE, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x11, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x10, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x70, 0xF0, 0xF0, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF0, 0xF0, 0xF0, 0xC0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF0, 0x00, 0x00, 0x22, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xE0, 0xFF, 0xFF, 0xCD, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF1, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xE0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xE0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xE0, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF0, 0x00, 0x00, 0x01, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF0, 0xF0, 0xF0, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0x70, 0xF0, 0xF0, 0xC0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0x88, 0x00, 0x00, 0x22, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x77, 0xFF, 0xFF, 0xCD, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F}, // 3
  {0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF0, 0xF0, 0xF0, 0xC1, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0x70, 0xF0, 0xF0, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0x88, 0x00, 0x10, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x77, 0xFF, 0xEE, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x11, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x10, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF0, 0xF0, 0xF0, 0xC0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0x70, 0xF0, 0xF0, 0xA2, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0x88, 0x00, 0x10, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x77, 0xFF, 0xEE, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x11, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x08, 0x00, 0x10, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x70, 0xF0, 0xF0, 0xE0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xF0, 0xF0, 0xF0, 0xC0, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0x00, 0x00, 0x00, 0x22, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0E, 0xFF, 0xFF, 0xFF, 0xCD, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F},
  {
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F,
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F
  }
};

u8 * const row[4][200] = {
  {0xc008, 0xc808, 0xd008, 0xd808, 0xe008, 0xe808, 0xf008, 0xf808,
    0xc058, 0xc858, 0xd058, 0xd858, 0xe058, 0xe858, 0xf058, 0xf858,
    0xc0a8, 0xc8a8, 0xd0a8, 0xd8a8, 0xe0a8, 0xe8a8, 0xf0a8, 0xf8a8,
    0xc0f8, 0xc8f8, 0xd0f8, 0xd8f8, 0xe0f8, 0xe8f8, 0xf0f8, 0xf8f8,
    0xc148, 0xc948, 0xd148, 0xd948, 0xe148, 0xe948, 0xf148, 0xf948,
    0xc198, 0xc998, 0xd198, 0xd998, 0xe198, 0xe998, 0xf198, 0xf998,
    0xc1e8, 0xc9e8, 0xd1e8, 0xd9e8, 0xe1e8, 0xe9e8, 0xf1e8, 0xf9e8,
    0xc238, 0xca38, 0xd238, 0xda38, 0xe238, 0xea38, 0xf238, 0xfa38,
    0xc288, 0xca88, 0xd288, 0xda88, 0xe288, 0xea88, 0xf288, 0xfa88,
    0xc2d8, 0xcad8, 0xd2d8, 0xdad8, 0xe2d8, 0xead8, 0xf2d8, 0xfad8,
    0xc328, 0xcb28, 0xd328, 0xdb28, 0xe328, 0xeb28, 0xf328, 0xfb28,
    0xc378, 0xcb78, 0xd378, 0xdb78, 0xe378, 0xeb78, 0xf378, 0xfb78,
    0xc3c8, 0xcbc8, 0xd3c8, 0xdbc8, 0xe3c8, 0xebc8, 0xf3c8, 0xfbc8,
    0xc418, 0xcc18, 0xd418, 0xdc18, 0xe418, 0xec18, 0xf418, 0xfc18,
    0xc468, 0xcc68, 0xd468, 0xdc68, 0xe468, 0xec68, 0xf468, 0xfc68,
    0xc4b8, 0xccb8, 0xd4b8, 0xdcb8, 0xe4b8, 0xecb8, 0xf4b8, 0xfcb8,
    0xc508, 0xcd08, 0xd508, 0xdd08, 0xe508, 0xed08, 0xf508, 0xfd08,
    0xc558, 0xcd58, 0xd558, 0xdd58, 0xe558, 0xed58, 0xf558, 0xfd58,
    0xc5a8, 0xcda8, 0xd5a8, 0xdda8, 0xe5a8, 0xeda8, 0xf5a8, 0xfda8,
    0xc5f8, 0xcdf8, 0xd5f8, 0xddf8, 0xe5f8, 0xedf8, 0xf5f8, 0xfdf8,
    0xc648, 0xce48, 0xd648, 0xde48, 0xe648, 0xee48, 0xf648, 0xfe48,
    0xc698, 0xce98, 0xd698, 0xde98, 0xe698, 0xee98, 0xf698, 0xfe98,
    0xc6e8, 0xcee8, 0xd6e8, 0xdee8, 0xe6e8, 0xeee8, 0xf6e8, 0xfee8,
    0xc738, 0xcf38, 0xd738, 0xdf38, 0xe738, 0xef38, 0xf738, 0xff38,
    0xc788, 0xcf88, 0xd788, 0xdf88, 0xe788, 0xef88, 0xf788, 0xff88},
  {0xc01c, 0xc81c, 0xd01c, 0xd81c, 0xe01c, 0xe81c, 0xf01c, 0xf81c,
    0xc06c, 0xc86c, 0xd06c, 0xd86c, 0xe06c, 0xe86c, 0xf06c, 0xf86c,
    0xc0bc, 0xc8bc, 0xd0bc, 0xd8bc, 0xe0bc, 0xe8bc, 0xf0bc, 0xf8bc,
    0xc10c, 0xc90c, 0xd10c, 0xd90c, 0xe10c, 0xe90c, 0xf10c, 0xf90c,
    0xc15c, 0xc95c, 0xd15c, 0xd95c, 0xe15c, 0xe95c, 0xf15c, 0xf95c,
    0xc1ac, 0xc9ac, 0xd1ac, 0xd9ac, 0xe1ac, 0xe9ac, 0xf1ac, 0xf9ac,
    0xc1fc, 0xc9fc, 0xd1fc, 0xd9fc, 0xe1fc, 0xe9fc, 0xf1fc, 0xf9fc,
    0xc24c, 0xca4c, 0xd24c, 0xda4c, 0xe24c, 0xea4c, 0xf24c, 0xfa4c,
    0xc29c, 0xca9c, 0xd29c, 0xda9c, 0xe29c, 0xea9c, 0xf29c, 0xfa9c,
    0xc2ec, 0xcaec, 0xd2ec, 0xdaec, 0xe2ec, 0xeaec, 0xf2ec, 0xfaec,
    0xc33c, 0xcb3c, 0xd33c, 0xdb3c, 0xe33c, 0xeb3c, 0xf33c, 0xfb3c,
    0xc38c, 0xcb8c, 0xd38c, 0xdb8c, 0xe38c, 0xeb8c, 0xf38c, 0xfb8c,
    0xc3dc, 0xcbdc, 0xd3dc, 0xdbdc, 0xe3dc, 0xebdc, 0xf3dc, 0xfbdc,
    0xc42c, 0xcc2c, 0xd42c, 0xdc2c, 0xe42c, 0xec2c, 0xf42c, 0xfc2c,
    0xc47c, 0xcc7c, 0xd47c, 0xdc7c, 0xe47c, 0xec7c, 0xf47c, 0xfc7c,
    0xc4cc, 0xcccc, 0xd4cc, 0xdccc, 0xe4cc, 0xeccc, 0xf4cc, 0xfccc,
    0xc51c, 0xcd1c, 0xd51c, 0xdd1c, 0xe51c, 0xed1c, 0xf51c, 0xfd1c,
    0xc56c, 0xcd6c, 0xd56c, 0xdd6c, 0xe56c, 0xed6c, 0xf56c, 0xfd6c,
    0xc5bc, 0xcdbc, 0xd5bc, 0xddbc, 0xe5bc, 0xedbc, 0xf5bc, 0xfdbc,
    0xc60c, 0xce0c, 0xd60c, 0xde0c, 0xe60c, 0xee0c, 0xf60c, 0xfe0c,
    0xc65c, 0xce5c, 0xd65c, 0xde5c, 0xe65c, 0xee5c, 0xf65c, 0xfe5c,
    0xc6ac, 0xceac, 0xd6ac, 0xdeac, 0xe6ac, 0xeeac, 0xf6ac, 0xfeac,
    0xc6fc, 0xcefc, 0xd6fc, 0xdefc, 0xe6fc, 0xeefc, 0xf6fc, 0xfefc,
    0xc74c, 0xcf4c, 0xd74c, 0xdf4c, 0xe74c, 0xef4c, 0xf74c, 0xff4c,
    0xc79c, 0xcf9c, 0xd79c, 0xdf9c, 0xe79c, 0xef9c, 0xf79c, 0xff9c},
  {0xc030, 0xc830, 0xd030, 0xd830, 0xe030, 0xe830, 0xf030, 0xf830,
    0xc080, 0xc880, 0xd080, 0xd880, 0xe080, 0xe880, 0xf080, 0xf880,
    0xc0d0, 0xc8d0, 0xd0d0, 0xd8d0, 0xe0d0, 0xe8d0, 0xf0d0, 0xf8d0,
    0xc120, 0xc920, 0xd120, 0xd920, 0xe120, 0xe920, 0xf120, 0xf920,
    0xc170, 0xc970, 0xd170, 0xd970, 0xe170, 0xe970, 0xf170, 0xf970,
    0xc1c0, 0xc9c0, 0xd1c0, 0xd9c0, 0xe1c0, 0xe9c0, 0xf1c0, 0xf9c0,
    0xc210, 0xca10, 0xd210, 0xda10, 0xe210, 0xea10, 0xf210, 0xfa10,
    0xc260, 0xca60, 0xd260, 0xda60, 0xe260, 0xea60, 0xf260, 0xfa60,
    0xc2b0, 0xcab0, 0xd2b0, 0xdab0, 0xe2b0, 0xeab0, 0xf2b0, 0xfab0,
    0xc300, 0xcb00, 0xd300, 0xdb00, 0xe300, 0xeb00, 0xf300, 0xfb00,
    0xc350, 0xcb50, 0xd350, 0xdb50, 0xe350, 0xeb50, 0xf350, 0xfb50,
    0xc3a0, 0xcba0, 0xd3a0, 0xdba0, 0xe3a0, 0xeba0, 0xf3a0, 0xfba0,
    0xc3f0, 0xcbf0, 0xd3f0, 0xdbf0, 0xe3f0, 0xebf0, 0xf3f0, 0xfbf0,
    0xc440, 0xcc40, 0xd440, 0xdc40, 0xe440, 0xec40, 0xf440, 0xfc40,
    0xc490, 0xcc90, 0xd490, 0xdc90, 0xe490, 0xec90, 0xf490, 0xfc90,
    0xc4e0, 0xcce0, 0xd4e0, 0xdce0, 0xe4e0, 0xece0, 0xf4e0, 0xfce0,
    0xc530, 0xcd30, 0xd530, 0xdd30, 0xe530, 0xed30, 0xf530, 0xfd30,
    0xc580, 0xcd80, 0xd580, 0xdd80, 0xe580, 0xed80, 0xf580, 0xfd80,
    0xc5d0, 0xcdd0, 0xd5d0, 0xddd0, 0xe5d0, 0xedd0, 0xf5d0, 0xfdd0,
    0xc620, 0xce20, 0xd620, 0xde20, 0xe620, 0xee20, 0xf620, 0xfe20,
    0xc670, 0xce70, 0xd670, 0xde70, 0xe670, 0xee70, 0xf670, 0xfe70,
    0xc6c0, 0xcec0, 0xd6c0, 0xdec0, 0xe6c0, 0xeec0, 0xf6c0, 0xfec0,
    0xc710, 0xcf10, 0xd710, 0xdf10, 0xe710, 0xef10, 0xf710, 0xff10,
    0xc760, 0xcf60, 0xd760, 0xdf60, 0xe760, 0xef60, 0xf760, 0xff60,
    0xc7b0, 0xcfb0, 0xd7b0, 0xdfb0, 0xe7b0, 0xefb0, 0xf7b0, 0xffb0},
  {0xc044, 0xc844, 0xd044, 0xd844, 0xe044, 0xe844, 0xf044, 0xf844,
    0xc094, 0xc894, 0xd094, 0xd894, 0xe094, 0xe894, 0xf094, 0xf894,
    0xc0e4, 0xc8e4, 0xd0e4, 0xd8e4, 0xe0e4, 0xe8e4, 0xf0e4, 0xf8e4,
    0xc134, 0xc934, 0xd134, 0xd934, 0xe134, 0xe934, 0xf134, 0xf934,
    0xc184, 0xc984, 0xd184, 0xd984, 0xe184, 0xe984, 0xf184, 0xf984,
    0xc1d4, 0xc9d4, 0xd1d4, 0xd9d4, 0xe1d4, 0xe9d4, 0xf1d4, 0xf9d4,
    0xc224, 0xca24, 0xd224, 0xda24, 0xe224, 0xea24, 0xf224, 0xfa24,
    0xc274, 0xca74, 0xd274, 0xda74, 0xe274, 0xea74, 0xf274, 0xfa74,
    0xc2c4, 0xcac4, 0xd2c4, 0xdac4, 0xe2c4, 0xeac4, 0xf2c4, 0xfac4,
    0xc314, 0xcb14, 0xd314, 0xdb14, 0xe314, 0xeb14, 0xf314, 0xfb14,
    0xc364, 0xcb64, 0xd364, 0xdb64, 0xe364, 0xeb64, 0xf364, 0xfb64,
    0xc3b4, 0xcbb4, 0xd3b4, 0xdbb4, 0xe3b4, 0xebb4, 0xf3b4, 0xfbb4,
    0xc404, 0xcc04, 0xd404, 0xdc04, 0xe404, 0xec04, 0xf404, 0xfc04,
    0xc454, 0xcc54, 0xd454, 0xdc54, 0xe454, 0xec54, 0xf454, 0xfc54,
    0xc4a4, 0xcca4, 0xd4a4, 0xdca4, 0xe4a4, 0xeca4, 0xf4a4, 0xfca4,
    0xc4f4, 0xccf4, 0xd4f4, 0xdcf4, 0xe4f4, 0xecf4, 0xf4f4, 0xfcf4,
    0xc544, 0xcd44, 0xd544, 0xdd44, 0xe544, 0xed44, 0xf544, 0xfd44,
    0xc594, 0xcd94, 0xd594, 0xdd94, 0xe594, 0xed94, 0xf594, 0xfd94,
    0xc5e4, 0xcde4, 0xd5e4, 0xdde4, 0xe5e4, 0xede4, 0xf5e4, 0xfde4,
    0xc634, 0xce34, 0xd634, 0xde34, 0xe634, 0xee34, 0xf634, 0xfe34,
    0xc684, 0xce84, 0xd684, 0xde84, 0xe684, 0xee84, 0xf684, 0xfe84,
    0xc6d4, 0xced4, 0xd6d4, 0xded4, 0xe6d4, 0xeed4, 0xf6d4, 0xfed4,
    0xc724, 0xcf24, 0xd724, 0xdf24, 0xe724, 0xef24, 0xf724, 0xff24,
    0xc774, 0xcf74, 0xd774, 0xdf74, 0xe774, 0xef74, 0xf774, 0xff74,
    0xc7c4, 0xcfc4, 0xd7c4, 0xdfc4, 0xe7c4, 0xefc4, 0xf7c4, 0xffc4}
};
